<?php
require '../dbconfig.php';

$link = "modify-vehicle.php";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$id = $_POST['trackid'];

// Fetch existing data
$sql_fetch = "SELECT * FROM vehicles WHERE ID = ?";
$stmt = $conn->prepare($sql_fetch);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
} else {
    die("Error: Vehicle with ID $id not found.");
}

// Use existing data if POST values are empty
$name = !empty($_POST['name']) ? $_POST['name'] : $row['name'];
$number = !empty($_POST['number']) ? $_POST['number'] : $row['number'];
$title = !empty($_POST['title']) ? $_POST['title'] : $row['title'];
$adresa = !empty($_POST['adresa']) ? $_POST['adresa'] : $row['adresa'];
$pret = !empty($_POST['pret']) ? $_POST['pret'] : $row['pret'];
$odometer = !empty($_POST['odometer']) ? $_POST['odometer'] : $row['odometer'];
$body = !empty($_POST['body']) ? $_POST['body'] : $row['body'];
$fuel = !empty($_POST['fuel']) ? $_POST['fuel'] : $row['fuel'];
$transmission = !empty($_POST['transmission']) ? $_POST['transmission'] : $row['transmission'];
$comments = !empty($_POST['comments']) ? $_POST['comments'] : $row['comments'];
$overview = !empty($_POST['overview']) ? $_POST['overview'] : $row['overview'];
$feats = !empty($_POST['feats']) ? $_POST['feats'] : $row['feats'];
$specs = !empty($_POST['specs']) ? $_POST['specs'] : $row['specs'];

// Prepare SQL update statement
$sql = "UPDATE vehicles SET title = ?, name = ?, number = ?, adresa = ?, pret = ?, 
        odometer = ?, body = ?, fuel = ?, transmission = ?, comments = ?, overview = ?, 
        feats = ?, specs = ? WHERE ID = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("sssssssssssssi", $title, $name, $number, $adresa, $pret, 
                                       $odometer, $body, $fuel, $transmission, $comments, 
                                       $overview, $feats, $specs, $id);

// Execute the statement
if ($stmt->execute()) {
    echo "Vehicle successfully updated: '" . htmlspecialchars($id) . "' <br> <a href='$link'>Go Back</a>";
} else {
    echo "Error: " . $stmt->error;
}

// Close connections
$stmt->close();
$conn->close();
?>
