<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
require 'PHPMailer/src/Exception.php';

// 🔍 DEBUG: Log raw input, POST, and REQUEST data
file_put_contents("debug.log", "Raw Input:\n" . file_get_contents("php://input") . "\n", FILE_APPEND);
file_put_contents("debug.log", "POST Data:\n" . print_r($_POST, true) . "\n", FILE_APPEND);
file_put_contents("debug.log", "REQUEST Data:\n" . print_r($_REQUEST, true) . "\n", FILE_APPEND);

// ✅ HANDLE BOTH FORM-DATA AND JSON REQUESTS
$inputData = json_decode(file_get_contents("php://input"), true);

// If JSON request, use $inputData. Otherwise, use $_POST
$data = $inputData ? $inputData : $_POST;

// Extract values safely
$title = $data['title'] ?? 'No Title';
$fullName = $data['fullName'] ?? 'No Name';
$email = $data['email'] ?? 'No Email';
$message = $data['message'] ?? 'No Message';
$phone = $data['phone'] ?? 'No Phone';
$postcode = $data['postcode'] ?? 'No Postcode';

// 🔍 DEBUG: Log processed input data
file_put_contents("debug.log", "Processed Data:\n" . print_r($data, true) . "\n", FILE_APPEND);

$mail = new PHPMailer(true);

try {
    // SMTP Settings
    $mail->isSMTP();
    $mail->Host       = 'server320.web-hosting.com';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'info@carsaies.com.au';
    $mail->Password   = 'carsalescomau***';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = 587;

    // Sender & Recipient
    $mail->setFrom('info@carsaies.com.au', 'Admin');
    $mail->addAddress('info@carsaies.com.au');

    // Email Content
    $mail->isHTML(true);
    $mail->Subject = 'New Enquiry for ' . $title;
    $mail->Body    = "
        <h2>$title</h2>
        <p><strong>Name:</strong> $fullName</p>
        <p><strong>Email:</strong> $email</p>
        <p><strong>Message:</strong> $message</p>
        <p><strong>Phone:</strong> $phone</p>
        <p><strong>Postcode:</strong> $postcode</p>
    ";

    // Send Email
    $mail->send();
    echo json_encode(["success" => true, "message" => "Email sent successfully!"]);
} catch (Exception $e) {
    echo json_encode(["success" => false, "message" => "Mailer Error: {$mail->ErrorInfo}"]);
}
?>
